/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.bladestand;

import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.data.tag.SlashBladeItemTags;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.recipe.RequestDefinition;
import mods.flammpfeil.slashblade.recipe.SlashBladeIngredient;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import mods.flammpfeil.slashblade.registry.SpecialEffectsRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import mods.flammpfeil.slashblade.registry.specialeffects.SpecialEffect;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BlandStandEventHandler {
    @SubscribeEvent
    public static void eventKoseki(SlashBladeEvent.BladeStandAttackEvent event) {
        Registry<SlashBladeDefinition> slashBladeDefinitionRegistry = SlashBlade.getSlashBladeDefinitionRegistry(event.getBladeStand().m_9236_());
        if (!slashBladeDefinitionRegistry.m_7804_(SlashBladeBuiltInRegistry.KOSEKI.m_135782_())) {
            return;
        }
        if (!(event.getDamageSource().m_7639_() instanceof WitherBoss)) {
            return;
        }
        if (!event.getDamageSource().m_269533_(DamageTypeTags.f_268415_)) {
            return;
        }
        SlashBladeIngredient in = SlashBladeIngredient.of(RequestDefinition.Builder.newInstance().build());
        if (!in.test(event.getBlade())) {
            return;
        }
        event.getBladeStand().m_31805_(((SlashBladeDefinition)slashBladeDefinitionRegistry.m_6246_(SlashBladeBuiltInRegistry.KOSEKI)).getBlade());
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void eventChangeSE(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().m_7639_() instanceof ServerPlayer)) {
            return;
        }
        Player player = (Player)event.getDamageSource().m_7639_();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_150930_(SBItems.proudsoul_crystal)) {
            return;
        }
        Level world = player.m_9236_();
        ISlashBladeState state = event.getSlashBladeState();
        if (stack.m_41783_() == null) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128441_("SpecialEffectType")) {
            BladeStandEntity bladeStand = event.getBladeStand();
            ResourceLocation SEKey = new ResourceLocation(tag.m_128461_("SpecialEffectType"));
            if (!SpecialEffectsRegistry.REGISTRY.get().containsKey(SEKey)) {
                return;
            }
            if (state.hasSpecialEffect(SEKey)) {
                return;
            }
            state.addSpecialEffect(SEKey);
            RandomSource random = player.m_217043_();
            world.m_245803_((Entity)bladeStand, bladeStand.m_31748_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 32 && !player.m_9236_().m_5776_(); ++i) {
                double zDist;
                double yDist;
                double xDist = random.m_188501_() * 2.0f - 1.0f;
                if (xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist > 1.0) continue;
                double x = bladeStand.m_20165_(xDist / 4.0);
                double y = bladeStand.m_20227_(0.5 + yDist / 4.0);
                double z = bladeStand.m_20246_(zDist / 4.0);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void eventChangeSA(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().m_7639_() instanceof ServerPlayer)) {
            return;
        }
        Player player = (Player)event.getDamageSource().m_7639_();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        CompoundTag tag = stack.m_41783_();
        if (!stack.m_150930_(SBItems.proudsoul_sphere) || tag == null || !tag.m_128441_("SpecialAttackType")) {
            return;
        }
        ResourceLocation SAKey = new ResourceLocation(tag.m_128461_("SpecialAttackType"));
        if (!SlashArtsRegistry.REGISTRY.get().containsKey(SAKey)) {
            return;
        }
        ItemStack blade = event.getBlade();
        blade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            if (!SAKey.equals((Object)state.getSlashArtsKey())) {
                state.setSlashArtsKey(SAKey);
                RandomSource random = player.m_217043_();
                BladeStandEntity bladeStand = event.getBladeStand();
                player.m_9236_().m_245803_((Entity)bladeStand, bladeStand.m_31748_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < 32 && !player.m_9236_().m_5776_(); ++i) {
                    double zDist;
                    double yDist;
                    double xDist = random.m_188501_() * 2.0f - 1.0f;
                    if (xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist > 1.0) continue;
                    double x = bladeStand.m_20165_(xDist / 4.0);
                    double y = bladeStand.m_20227_(0.5 + yDist / 4.0);
                    double z = bladeStand.m_20246_(zDist / 4.0);
                    ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
            }
        });
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void eventCopySE(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().m_7639_() instanceof ServerPlayer)) {
            return;
        }
        Player player = (Player)event.getDamageSource().m_7639_();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_150930_(SBItems.proudsoul_crystal)) {
            return;
        }
        Level world = player.m_9236_();
        ISlashBladeState state = event.getSlashBladeState();
        BladeStandEntity bladeStand = event.getBladeStand();
        List<ResourceLocation> specialEffects = state.getSpecialEffects();
        for (ResourceLocation se : specialEffects) {
            if (!SpecialEffectsRegistry.REGISTRY.get().containsKey(se) || !((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(se)).isCopiable()) continue;
            ItemStack orb = new ItemStack((ItemLike)SBItems.proudsoul_crystal);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("SpecialEffectType", se.toString());
            orb.m_41751_(tag);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            RandomSource random = player.m_217043_();
            world.m_245803_((Entity)bladeStand, bladeStand.m_31748_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 32 && !world.m_5776_(); ++i) {
                double zDist;
                double yDist;
                double xDist = random.m_188501_() * 2.0f - 1.0f;
                if (xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist > 1.0) continue;
                double x = bladeStand.m_20165_(xDist / 4.0);
                double y = bladeStand.m_20227_(0.5 + yDist / 4.0);
                double z = bladeStand.m_20246_(zDist / 4.0);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
            }
            player.m_36176_(orb, true);
            if (((SpecialEffect)SpecialEffectsRegistry.REGISTRY.get().getValue(se)).isRemovable()) {
                state.removeSpecialEffect(se);
            }
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void eventCopySA(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().m_7639_() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamageSource().m_7639_();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_150930_(SBItems.proudsoul_ingot) || !stack.m_41793_()) {
            return;
        }
        Level world = player.m_9236_();
        ISlashBladeState state = event.getSlashBladeState();
        BladeStandEntity bladeStand = event.getBladeStand();
        Set enchantments = EnchantmentHelper.m_44831_((ItemStack)stack).keySet();
        ResourceLocation SA = state.getSlashArtsKey();
        if (SA != null && !SA.equals((Object)SlashArtsRegistry.NONE.getId())) {
            ItemStack orb = new ItemStack((ItemLike)SBItems.proudsoul_sphere);
            for (Enchantment e : enchantments) {
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)e, (ItemStack)blade) >= e.m_6586_()) continue;
                return;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("SpecialAttackType", state.getSlashArtsKey().toString());
            orb.m_41751_(tag);
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            world.m_245803_((Entity)bladeStand, bladeStand.m_31748_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
            RandomSource random = player.m_217043_();
            for (int i = 0; i < 32 && !world.m_5776_(); ++i) {
                double zDist;
                double yDist;
                double xDist = random.m_188501_() * 2.0f - 1.0f;
                if (xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist > 1.0) continue;
                double x = bladeStand.m_20165_(xDist / 4.0);
                double y = bladeStand.m_20227_(0.5 + yDist / 4.0);
                double z = bladeStand.m_20246_(zDist / 4.0);
                ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
            }
            player.m_36176_(orb, true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void eventProudSoulEnchantment(SlashBladeEvent.BladeStandAttackEvent event) {
        if (!(event.getDamageSource().m_7639_() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamageSource().m_7639_();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack blade = event.getBlade();
        if (blade.m_41619_()) {
            return;
        }
        if (!stack.m_204117_(SlashBladeItemTags.PROUD_SOULS)) {
            return;
        }
        if (!stack.m_41793_()) {
            return;
        }
        Level world = player.m_9236_();
        RandomSource random = world.m_213780_();
        BladeStandEntity bladeStand = event.getBladeStand();
        Map currentBladeEnchantments = blade.getAllEnchantments();
        stack.getAllEnchantments().forEach((enchantment, level) -> {
            if (event.isCanceled()) {
                return;
            }
            if (!blade.canApplyAtEnchantingTable(enchantment)) {
                return;
            }
            float probability = 1.0f;
            if (stack.m_150930_(SBItems.proudsoul_tiny)) {
                probability = 0.25f;
            }
            if (stack.m_150930_(SBItems.proudsoul)) {
                probability = 0.5f;
            }
            if (stack.m_150930_(SBItems.proudsoul_ingot)) {
                probability = 0.75f;
            }
            if (random.m_188501_() <= probability) {
                int enchantLevel = Math.min(enchantment.m_6586_(), EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)blade) + 1);
                currentBladeEnchantments.put(enchantment, enchantLevel);
                EnchantmentHelper.m_44865_((Map)currentBladeEnchantments, (ItemStack)blade);
                world.m_245803_((Entity)bladeStand, bladeStand.m_31748_(), SoundEvents.f_12563_, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < 32 && !player.m_9236_().m_5776_(); ++i) {
                    double zDist;
                    double yDist;
                    double xDist = random.m_188501_() * 2.0f - 1.0f;
                    if (xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist > 1.0) continue;
                    double x = bladeStand.m_20165_(xDist / 4.0);
                    double y = bladeStand.m_20227_(0.5 + yDist / 4.0);
                    double z = bladeStand.m_20246_(zDist / 4.0);
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
                }
            }
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            event.setCanceled(true);
        });
    }
}

